import { Link, useLocation } from 'react-router-dom'
import { motion } from 'framer-motion'
import { Film } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-film">
      <header className="header-film">
        <div className="container">
          <div className="header-content-film">
            <Link to="/" className="logo-film">
              <div className="logo-icon-film">
                <Film size={28} strokeWidth={2.5} />
              </div>
              <span className="logo-text-film">FilmCut</span>
            </Link>
            <nav className="nav-film">
              <Link 
                to="/" 
                className={`nav-link-film ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои проекты
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link-film ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-film">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

